/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.lad.binarization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import weka.classifiers.rules.lad.binarization.Cutpoints;
import weka.core.Instance;
import weka.core.Instances;

public class Binarization {
    private double mTolerance = 0.0;
    private HashMap<Double, TransitionElement> mFeatures;

    public Binarization(double cutpointTolerance) {
        this.mTolerance = cutpointTolerance;
        this.mFeatures = new HashMap();
    }

    public Cutpoints findCutpoints(Instances insts) throws Exception {
        if (this.mTolerance < 0.0) {
            throw new Exception("Binarization: Cutpoint tolerance must be greater than or equal to 0.");
        }
        Cutpoints cutpoints = new Cutpoints();
        int att = 0;
        while (att < insts.numAttributes()) {
            if (insts.classIndex() != att) {
                this.mapTransitions(insts, att);
                ArrayList<Double> array = this.mapTransitions(insts, att);
                Collections.sort(array);
                int o1 = 0;
                int next = 1;
                while (array.size() > next) {
                    int o2 = next++;
                    double variation = Math.abs(array.get(o1) - array.get(o2));
                    if (variation > this.mTolerance && this.hasTransition(array.get(o1), array.get(o2))) {
                        double media = array.get(o1) + variation / 2.0;
                        cutpoints.addCutpoint(att, media);
                    }
                    o1 = o2;
                }
            }
            ++att;
        }
        if (cutpoints.numCutpoints() == 0) {
            throw new Exception("Binarizarion: No cutpoint was found.");
        }
        this.mFeatures.clear();
        return cutpoints;
    }

    private ArrayList<Double> mapTransitions(Instances insts, int att) {
        this.mFeatures.clear();
        int numInstances = insts.numInstances();
        int index = 0;
        while (index < numInstances) {
            Instance inst = insts.instance(index);
            if (!inst.isMissing(att)) {
                double valor = inst.value(att);
                TransitionElement trans = this.mFeatures.get(valor);
                if (trans == null) {
                    trans = new TransitionElement();
                    this.mFeatures.put(valor, trans);
                }
                trans.set(inst.classValue());
            }
            ++index;
        }
        return new ArrayList<Double>(this.mFeatures.keySet());
    }

    private boolean hasTransition(double c1, double c2) {
        if (this.mFeatures.get((Object)Double.valueOf((double)c1)).positive && this.mFeatures.get((Object)Double.valueOf((double)c2)).negative) {
            return true;
        }
        return this.mFeatures.get((Object)Double.valueOf((double)c1)).negative && this.mFeatures.get((Object)Double.valueOf((double)c2)).positive;
    }

    public double getTolerance() {
        return this.mTolerance;
    }

    public void setTolerancia(double mTolerancia) {
        this.mTolerance = mTolerancia;
    }

    private class TransitionElement
    implements Serializable {
        private static final long serialVersionUID = -4184858552280919519L;
        boolean positive = false;
        boolean negative = false;

        private TransitionElement() {
        }

        public void set(double aClass) {
            if (aClass == 0.0) {
                this.positive = true;
            } else {
                this.negative = true;
            }
        }
    }
}

